<?php

/*
Plugin Name: VideoPro - Sample Data
Description: Import sample data for VideoPro
Author: CactusThemes
Version: 1.3.3
Author URI: http://cactusthemes.com
*/

defined( 'ABSPATH' ) or die( 'You cannot access this script directly' );

// can we read directory automatically? No, it is considered "unsecured"!!!
$packages = array('default', 'poster', 'cooking', 'v2');
$base_dir = plugin_dir_path(__FILE__);
$base_uri = plugins_url('videopro-sampledata') . '/';

include 'cactus_importer.php';
$cactus_importer = new cactus_demo_importer($packages, $base_dir, $base_uri);


/**
 * Additional links on plugins page
 *
 * @param array
 * @param string
 * @return array
 */
function videoProSampleDataSetPluginMeta($links, $file)
{
    $demo_link = get_site_url() . '/wp-admin/themes.php?page=videopro-welcome&tab=sample';
    if (strpos($file, 'videopro-sampledata/videopro-sampledata.php') !== false) {
        $new_links = array(
            '<a href="' . $demo_link . '" target="_blank">' . __('Click here to install demo data', 'cactus') . '</a>',
        );

        $links = array_merge($links, $new_links);
    }

    return $links;
}

add_filter('plugin_row_meta', 'videoProSampleDataSetPluginMeta', 10, 2);